--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A Template is the top level component in MCM. It determines the overall layout of the menu. Can be created with a table or a string (name).
--- @class mwseMCMTemplate : mwseMCMComponent
--- @field componentType "Template" The type of this component.
--- @field config table|nil Stores a config that should be used by this mod's `Setting`s. Sub-configs can be accessed by passing a `configKey` to any `Page`s nested inside this template. If provided, this config will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this template.
--- @field currentPage mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMMouseOverPage|mwseMCMPage|mwseMCMSideBarPage The currently displayed page in this Template.
--- @field defaultConfig table|nil Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod.
--- @field elements mwseMCMTemplateElements This dictionary-style table holds all the UI elements of the Template, for easy access.
--- @field headerImagePath string|nil The path to the header image. It's relative to `Data Files/`. The image must have power-of-2 dimensions (i.e. 16, 32, 64, 128, 256, 512, 1024, etc.).
--- @field name string The name field is the mod name, used to register the MCM, and is displayed in the mod list on the lefthand pane.
--- @field onClose nil|fun(modConfigContainer: tes3uiElement) A function which will be called when the menu is closed. Useful for saving your config after exiting the MCM.
--- 
--- Use `template:saveOnClose(configFilename, configTable)` to assign a simple save function to onClose. If you want to do more on closing, assign a custom function to `onClose` and call `mwse.saveConfig(configFilename, configTable)` when you want to save.
--- 
--- @field onSearch nil|fun(searchText: string): boolean A custom search handler function. This function should return true if this mod Template should show up in search results for given `searchText` (it's in lowercase).
--- @field pages mwseMCMExclusionsPage[]|mwseMCMFilterPage[]|mwseMCMMouseOverPage[]|mwseMCMPage[]|mwseMCMSideBarPage[] Pages in this Template.
--- @field searchChildDescriptions boolean If true, when the user searches the MCM list, all the pages and settings in this MCM template will be searched over. The matching will be performed on setting `description` fields.
--- @field searchChildLabels boolean If true, when the user searches the MCM list, all the pages and settings in this MCM template will be searched over. The matching will be performed on setting `label` and `text` fields.
--- @field showDefaultSetting boolean If `true`, then each `Page` created inside this `Template` will have `showDefaultSetting = true`. \z
--- This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Page` created in this `Template`.
mwseMCMTemplate = {}

--- Destroys the currently display page and creates the given page as the new current page.
--- @param thisPage mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMMouseOverPage|mwseMCMPage|mwseMCMSideBarPage No description yet available.
function mwseMCMTemplate:clickTab(thisPage) end

--- This method creates the UI elements specific to a Template.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTemplate:createContentsContainer(parentBlock) end

--- Creates a new Exclusions Page in this Template.
--- @param data mwseMCMTemplate.createExclusionsPage.data This table accepts the following values:
--- 
--- `showHeader?`: boolean — *Default*: `false`. The page's label will only be created if set to true.
--- 
--- `showReset?`: boolean — *Default*: `false`. When set to true, the ExclusionsPage will have a Reset button. Clicking on it will set the `variable.value` to the `variable.defaultSetting` value.
--- 
--- `label`: string — The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- 
--- `variable?`: mwseMCMConfigVariable|mwseMCMCustomVariable|mwseMCMGlobal|mwseMCMGlobalBoolean|mwseMCMPlayerData|mwseMCMTableVariable|mwseMCMVariable|mwseMCMSettingNewVariable — *Optional*. The Variable used to store blocked list entries.
--- 
--- `config?`: table — *Default*: ``parentComponent.config``. The config to use when creating a [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) for this `ExclusionsPage`. If provided, it will override the config stored in `parentComponent`. Otherwise, the value in `parentComponent` will be used.
--- 
--- `defaultConfig?`: table — *Default*: ``parentComponent.defaultConfig``. The `defaultConfig` to use when creating a [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) for this `ExclusionsPage`. If provided, it will override the `defaultConfig` stored in `parentComponent`. Otherwise, the value in `parentComponent` will be used.
--- 
--- `configKey?`: string|number — *Optional*. The `configKey` used to create a new [`mwseMCMTableVariable`](./mwseMCMTableVariable.md). If this is provided, along with a `config` (which may be inherited from the `parentComponent`), then a new [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) variable will be created for this `ExclusionsPage`.
--- 
--- `defaultSetting?`: table<string, boolean> — *Optional*. If `defaultSetting` wasn't passed in the `variable` table, can be passed here. The new variable will be initialized to this value. If not provided, then the value in `defaultConfig` will be used, if possible.
--- 
--- `filters`: mwseMCMExclusionsPageFilter[] — A list of filters. Filters control which items will appear in the lists of the Exclusions Page. At least one filter is required. See the [filter page](./mwseMCMExclusionsPageFilter.md) for description.
--- 
--- `description?`: string — *Optional*. Displayed at the top of the page above the lists.
--- 
--- `toggleText?`: string — *Optional*. The text for the button that toggles filtered items from one list to another. The default is a localised version of "Toggle Filtered".
--- 
--- `leftListLabel ?`: string — *Optional*. The label on the left list. The default is a localised version of "Blocked".
--- 
--- `rightListLabel ?`: string — *Optional*. The label on the right list. The default is a localised version of "Allowed".
--- 
--- `showAllBlocked ?`: boolean — *Default*: `false`. When set to true, the left list shows all items in the blocked table, regardless of the filter being used.
--- 
--- `indent?`: integer — *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- @return mwseMCMExclusionsPage page No description yet available.
function mwseMCMTemplate:createExclusionsPage(data) end

---Table parameter definitions for `mwseMCMTemplate.createExclusionsPage`.
--- @class mwseMCMTemplate.createExclusionsPage.data
--- @field showHeader? boolean *Default*: `false`. The page's label will only be created if set to true.
--- @field showReset? boolean *Default*: `false`. When set to true, the ExclusionsPage will have a Reset button. Clicking on it will set the `variable.value` to the `variable.defaultSetting` value.
--- @field label string The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- @field variable? mwseMCMConfigVariable|mwseMCMCustomVariable|mwseMCMGlobal|mwseMCMGlobalBoolean|mwseMCMPlayerData|mwseMCMTableVariable|mwseMCMVariable|mwseMCMSettingNewVariable *Optional*. The Variable used to store blocked list entries.
--- @field config? table *Default*: ``parentComponent.config``. The config to use when creating a [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) for this `ExclusionsPage`. If provided, it will override the config stored in `parentComponent`. Otherwise, the value in `parentComponent` will be used.
--- @field defaultConfig? table *Default*: ``parentComponent.defaultConfig``. The `defaultConfig` to use when creating a [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) for this `ExclusionsPage`. If provided, it will override the `defaultConfig` stored in `parentComponent`. Otherwise, the value in `parentComponent` will be used.
--- @field configKey? string|number *Optional*. The `configKey` used to create a new [`mwseMCMTableVariable`](./mwseMCMTableVariable.md). If this is provided, along with a `config` (which may be inherited from the `parentComponent`), then a new [`mwseMCMTableVariable`](./mwseMCMTableVariable.md) variable will be created for this `ExclusionsPage`.
--- @field defaultSetting? table<string, boolean> *Optional*. If `defaultSetting` wasn't passed in the `variable` table, can be passed here. The new variable will be initialized to this value. If not provided, then the value in `defaultConfig` will be used, if possible.
--- @field filters mwseMCMExclusionsPageFilter[] A list of filters. Filters control which items will appear in the lists of the Exclusions Page. At least one filter is required. See the [filter page](./mwseMCMExclusionsPageFilter.md) for description.
--- @field description? string *Optional*. Displayed at the top of the page above the lists.
--- @field toggleText? string *Optional*. The text for the button that toggles filtered items from one list to another. The default is a localised version of "Toggle Filtered".
--- @field leftListLabel ? string *Optional*. The label on the left list. The default is a localised version of "Blocked".
--- @field rightListLabel ? string *Optional*. The label on the right list. The default is a localised version of "Allowed".
--- @field showAllBlocked ? boolean *Default*: `false`. When set to true, the left list shows all items in the blocked table, regardless of the filter being used.
--- @field indent? integer *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.

--- Creates a new Filter Page in this Template.
--- @param data? string|mwseMCMTemplate.createFilterPage.data This table accepts the following values:
--- 
--- `showHeader?`: boolean — *Default*: `false`. The page's label will only be created if set to true.
--- 
--- `label?`: string — *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- 
--- `noScroll?`: boolean — *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- 
--- `showReset?`: boolean — *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- 
--- `config?`: table — *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `defaultConfig?`: table — *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `configKey?`: string|number — *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- 
--- `description?`: string — *Optional*. Default sidebar text shown when the mouse isn't hovering over a component inside this Sidebar Page. It will be added to right column as a mwseMCMInfo.
--- 
--- `placeholderSearchText?`: string — *Default*: `Search...`. The text shown in the search bar when no text is entered.
--- 
--- `components?`: mwseMCMComponent.new.data[] — *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- 
--- `indent?`: integer — *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- 
--- `postCreate?`: fun(self: mwseMCMFilterPage) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @return mwseMCMFilterPage page No description yet available.
function mwseMCMTemplate:createFilterPage(data) end

---Table parameter definitions for `mwseMCMTemplate.createFilterPage`.
--- @class mwseMCMTemplate.createFilterPage.data
--- @field showHeader? boolean *Default*: `false`. The page's label will only be created if set to true.
--- @field label? string *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- @field noScroll? boolean *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- @field showReset? boolean *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- @field config? table *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field defaultConfig? table *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field configKey? string|number *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- @field description? string *Optional*. Default sidebar text shown when the mouse isn't hovering over a component inside this Sidebar Page. It will be added to right column as a mwseMCMInfo.
--- @field placeholderSearchText? string *Default*: `Search...`. The text shown in the search bar when no text is entered.
--- @field components? mwseMCMComponent.new.data[] *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- @field indent? integer *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.
--- @field postCreate? fun(self: mwseMCMFilterPage) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.

--- If a Template has headerImagePath defined, this method creates an image UI element from image at given path. If not, creates a label UI block with `self.label` text.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTemplate:createLabel(parentBlock) end

--- Creates a new MouseOverPage in this Template.
--- @param data? mwseMCMTemplate.createMouseOverPage.data This table accepts the following values:
--- 
--- `showHeader?`: boolean — *Default*: `false`. The page's label will only be created if set to true.
--- 
--- `label?`: string — *Optional*. The page label.
--- 
--- `noScroll?`: boolean — *Default*: `true`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- 
--- `config?`: table — *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `defaultConfig?`: table — *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `configKey?`: string|number — *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- 
--- `components?`: mwseMCMComponent.new.data[] — *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- 
--- `indent?`: integer — *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- 
--- `postCreate?`: fun(self: mwseMCMMouseOverPage) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @return mwseMCMMouseOverPage page No description yet available.
function mwseMCMTemplate:createMouseOverPage(data) end

---Table parameter definitions for `mwseMCMTemplate.createMouseOverPage`.
--- @class mwseMCMTemplate.createMouseOverPage.data
--- @field showHeader? boolean *Default*: `false`. The page's label will only be created if set to true.
--- @field label? string *Optional*. The page label.
--- @field noScroll? boolean *Default*: `true`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- @field config? table *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field defaultConfig? table *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field configKey? string|number *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- @field components? mwseMCMComponent.new.data[] *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- @field indent? integer *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.
--- @field postCreate? fun(self: mwseMCMMouseOverPage) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.

--- Creates a new Page in this Template.
--- @param data? string|mwseMCMTemplate.createPage.data This table accepts the following values:
--- 
--- `showHeader?`: boolean — *Default*: `false`. The page's label will only be created if set to true.
--- 
--- `label?`: string — *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- 
--- `noScroll?`: boolean — *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- 
--- `showReset?`: boolean — *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- 
--- `config?`: table — *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `defaultConfig?`: table — *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `configKey?`: string|number — *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- 
--- `showDefaultSetting?`: boolean — *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Setting` created inside this `Page`/`Category` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Setting` created in this `Page`/`Category`.
--- 
--- `components?`: mwseMCMComponent.new.data[] — *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- 
--- `indent?`: integer — *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- 
--- `postCreate?`: fun(self: mwseMCMPage) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @return mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMMouseOverPage|mwseMCMPage|mwseMCMSideBarPage page No description yet available.
function mwseMCMTemplate:createPage(data) end

---Table parameter definitions for `mwseMCMTemplate.createPage`.
--- @class mwseMCMTemplate.createPage.data
--- @field showHeader? boolean *Default*: `false`. The page's label will only be created if set to true.
--- @field label? string *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- @field noScroll? boolean *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- @field showReset? boolean *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- @field config? table *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field defaultConfig? table *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field configKey? string|number *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- @field showDefaultSetting? boolean *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Setting` created inside this `Page`/`Category` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Setting` created in this `Page`/`Category`.
--- @field components? mwseMCMComponent.new.data[] *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- @field indent? integer *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.
--- @field postCreate? fun(self: mwseMCMPage) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.

--- Creates a new Sidebar Page in this Template.
--- @param data? string|mwseMCMTemplate.createSideBarPage.data This table accepts the following values:
--- 
--- `showHeader?`: boolean — *Default*: `false`. The page's label will only be created if set to true.
--- 
--- `label?`: string — *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- 
--- `noScroll?`: boolean — *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- 
--- `showReset?`: boolean — *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- 
--- `config?`: table — *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `defaultConfig?`: table — *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- 
--- `configKey?`: string|number — *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- 
--- `showDefaultSetting?`: boolean — *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Setting` created inside this `Page`/`Category` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Setting` created in this `Page`/`Category`.
--- 
--- `description?`: string — *Optional*. Default sidebar text shown when the mouse isn't hovering over a component inside this Sidebar Page. It will be added to right column as a mwseMCMInfo.
--- 
--- `components?`: mwseMCMComponent.new.data[] — *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- 
--- `indent?`: integer — *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- 
--- `postCreate?`: fun(self: mwseMCMSideBarPage) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @return mwseMCMFilterPage|mwseMCMSideBarPage page No description yet available.
function mwseMCMTemplate:createSideBarPage(data) end

---Table parameter definitions for `mwseMCMTemplate.createSideBarPage`.
--- @class mwseMCMTemplate.createSideBarPage.data
--- @field showHeader? boolean *Default*: `false`. The page's label will only be created if set to true.
--- @field label? string *Optional*. The label field is displayed in the tab for that page at the top of the menu. Defaults to: "Page {number}".
--- @field noScroll? boolean *Default*: `false`. When set to true, the page will not have a scrollbar. Particularly useful if you want to use a [ParagraphField](./mwseMCMParagraphField.md), which is not compatible with scroll panes.
--- @field showReset? boolean *Default*: `false`. When set to true, the Page will have a Reset button. Clicking on it will set the `variable.value` of all the setting on the page to their respective `defaultSetting` values.
--- @field config? table *Optional*. If provided, this `config` will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this `Category`/`Page`. i.e., this parameter provides an alternative to explicitly constructing new variables. Subtables of this `config` can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field defaultConfig? table *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod. Sub-configs can be accessed by passing a `configKey` to any `Category` that is nested inside this one.
--- @field configKey? string|number *Optional*. This can be used to access subtables of the `config` and `defaultConfig` stored in this component's `parentComponent`. This ensures that the `config` and `defaultConfig` stay synchronized.
--- @field showDefaultSetting? boolean *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Setting` created inside this `Page`/`Category` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Setting` created in this `Page`/`Category`.
--- @field description? string *Optional*. Default sidebar text shown when the mouse isn't hovering over a component inside this Sidebar Page. It will be added to right column as a mwseMCMInfo.
--- @field components? mwseMCMComponent.new.data[] *Optional*. Use this if you want to directly create all the nested components in this Page. This table is described at each Component's `new` method.
--- @field indent? integer *Default*: `6`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.
--- @field postCreate? fun(self: mwseMCMSideBarPage) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.

--- This method creates the pageBlock UI element and the first page of the Template.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTemplate:createSubcomponentsContainer(parentBlock) end

--- This method creates a button for given page in the tabsBlock UI elements of the Template. The button has an event handler registered on tes3.uiEvent.mouseClick that calls `self:clickTab(page)`.
--- @param page mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMMouseOverPage|mwseMCMPage|mwseMCMSideBarPage No description yet available.
function mwseMCMTemplate:createTab(page) end

--- This method creates the outerTabsBlock, previousTabButton, tabsBlock and nextTabButton UI elements of the Template. The page tabs aren't created if the Template contains only one page.
--- @param parentBlock tes3uiElement No description yet available.
function mwseMCMTemplate:createTabsBlock(parentBlock) end

--- Creates a new Template.
--- @param data mwseMCMTemplate.new.data This table accepts the following values:
--- 
--- `name?`: string — *Optional*. The name field is the mod name, used to register the MCM, and is displayed in the mod list on the lefthand pane.
--- 
--- `label?`: string — *Optional*. Used in place of `name` if that argument isn't passed. You need to pass at least one of the `name` and `label` arguments. If `headerImagePath` is not passed, a UI element will be created with `label` as text.
--- 
--- `config?`: table — *Optional*. Stores a config that should be used by this mod's `Setting`s. Sub-configs can be accessed by passing a `configKey` to any `Page`s nested inside this template. If provided, this config will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this template.
--- 
--- `defaultConfig?`: table — *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod.
--- 
--- `showDefaultSetting?`: boolean — *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Page` created inside this `Template` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Page` created in this `Template`.
--- 
--- `headerImagePath?`: string — *Optional*. Set it to display an image at the top of your menu. Path is relative to `Data Files/`. The image must have power-of-2 dimensions (i.e. 16, 32, 64, 128, 256, 512, 1024, etc.).
--- 
--- `onClose?`: fun(modConfigContainer: tes3uiElement) — *Optional*. Set this to a function which will be called when the menu is closed. Useful for saving variables, such as TableVariable.
--- 
--- `searchChildLabels?`: boolean — *Default*: `true`. If true, default search handler will search through all the page and setting `label` and `text` fields in this MCM template.
--- 
--- `searchChildDescriptions?`: boolean — *Default*: `true`. If true, default search handler will search through all the page and setting `description` fields in this MCM template.
--- 
--- `onSearch?`: fun(searchText: string): boolean — *Optional*. A custom search handler function. This function should return true if this mod Template should show up in search results for given `searchText` (it's in lowercase).
--- 
--- `pages?`: mwseMCMPage.new.data[] — *Optional*. You can create pages for the template directly here. The entries in the array must specify the class of the page.
--- 
--- `indent?`: integer — *Default*: `12`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- 
--- `childIndent?`: integer — *Optional*. The left padding size in pixels. Used on all the child components.
--- 
--- `paddingBottom?`: integer — *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- 
--- `childSpacing?`: integer — *Optional*. The bottom border size in pixels. Used on all the child components.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. No description yet available.
--- 
--- `postCreate?`: fun(self: mwseMCMTemplate) — *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- 
--- `class?`: string — *Optional*. No description yet available.
--- 
--- `parentComponent?`: mwseMCMActiveInfo|mwseMCMBinder|mwseMCMButton|mwseMCMCategory|mwseMCMColorPicker|mwseMCMColorPickerButton|mwseMCMComponent|mwseMCMCycleButton|mwseMCMDropdown|mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMHyperlink|mwseMCMInfo|mwseMCMKeyBinder|mwseMCMLogLevelOptions|mwseMCMMouseBinder|mwseMCMMouseOverInfo|mwseMCMMouseOverPage|mwseMCMOnOffButton|mwseMCMPage|mwseMCMParagraphField|mwseMCMPercentageSlider|mwseMCMSetting|mwseMCMSideBarPage|mwseMCMSideBySideBlock|mwseMCMSlider|mwseMCMTemplate|mwseMCMTextField|mwseMCMYesNoButton — *Optional*. No description yet available.
--- @return mwseMCMTemplate template No description yet available.
function mwseMCMTemplate:new(data) end

---Table parameter definitions for `mwseMCMTemplate.new`.
--- @class mwseMCMTemplate.new.data
--- @field name? string *Optional*. The name field is the mod name, used to register the MCM, and is displayed in the mod list on the lefthand pane.
--- @field label? string *Optional*. Used in place of `name` if that argument isn't passed. You need to pass at least one of the `name` and `label` arguments. If `headerImagePath` is not passed, a UI element will be created with `label` as text.
--- @field config? table *Optional*. Stores a config that should be used by this mod's `Setting`s. Sub-configs can be accessed by passing a `configKey` to any `Page`s nested inside this template. If provided, this config will be used to generate [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) for any [`mwseMCMSetting`s](./mwseMCMSetting.md) made inside this template.
--- @field defaultConfig? table *Optional*. Stores a default config that should be used by this mod's `Setting`s. This will initialize the `defaultSetting` field of any [`mwseMCMTableVariable`s](./mwseMCMTableVariable.md) created for this mod.
--- @field showDefaultSetting? boolean *Default*: ``parentComponent.showDefaultSetting``. If `true`, then each `Page` created inside this `Template` will have `showDefaultSetting = true`. This is equivalent to manually writing `showDefaultSetting = true` in the constructor of each `Page` created in this `Template`.
--- @field headerImagePath? string *Optional*. Set it to display an image at the top of your menu. Path is relative to `Data Files/`. The image must have power-of-2 dimensions (i.e. 16, 32, 64, 128, 256, 512, 1024, etc.).
--- @field onClose? fun(modConfigContainer: tes3uiElement) *Optional*. Set this to a function which will be called when the menu is closed. Useful for saving variables, such as TableVariable.
--- @field searchChildLabels? boolean *Default*: `true`. If true, default search handler will search through all the page and setting `label` and `text` fields in this MCM template.
--- @field searchChildDescriptions? boolean *Default*: `true`. If true, default search handler will search through all the page and setting `description` fields in this MCM template.
--- @field onSearch? fun(searchText: string): boolean *Optional*. A custom search handler function. This function should return true if this mod Template should show up in search results for given `searchText` (it's in lowercase).
--- @field pages? mwseMCMPage.new.data[] *Optional*. You can create pages for the template directly here. The entries in the array must specify the class of the page.
--- @field indent? integer *Default*: `12`. The left padding size in pixels. Only used if the `childIndent` isn't set on the parent component.
--- @field childIndent? integer *Optional*. The left padding size in pixels. Used on all the child components.
--- @field paddingBottom? integer *Default*: `4`. The bottom border size in pixels. Only used if the `childSpacing` is unset on the parent component.
--- @field childSpacing? integer *Optional*. The bottom border size in pixels. Used on all the child components.
--- @field inGameOnly? boolean *Default*: `false`. No description yet available.
--- @field postCreate? fun(self: mwseMCMTemplate) *Optional*. Can define a custom formatting function to make adjustments to any element saved in `self.elements`.
--- @field class? string *Optional*. No description yet available.
--- @field parentComponent? mwseMCMActiveInfo|mwseMCMBinder|mwseMCMButton|mwseMCMCategory|mwseMCMColorPicker|mwseMCMColorPickerButton|mwseMCMComponent|mwseMCMCycleButton|mwseMCMDropdown|mwseMCMExclusionsPage|mwseMCMFilterPage|mwseMCMHyperlink|mwseMCMInfo|mwseMCMKeyBinder|mwseMCMLogLevelOptions|mwseMCMMouseBinder|mwseMCMMouseOverInfo|mwseMCMMouseOverPage|mwseMCMOnOffButton|mwseMCMPage|mwseMCMParagraphField|mwseMCMPercentageSlider|mwseMCMSetting|mwseMCMSideBarPage|mwseMCMSideBySideBlock|mwseMCMSlider|mwseMCMTemplate|mwseMCMTextField|mwseMCMYesNoButton *Optional*. No description yet available.

--- Performs searching routine for given `searchText`.
--- @param searchText string No description yet available.
--- @return boolean result True if given `searchText` matches this MCM template.
function mwseMCMTemplate:onSearchInternal(searchText) end

--- A convenience function that registers the mod's configuration menu using its Template. In addition, sets `self:onSearchInternal` as the `onSearch` handler.
--- 
--- You don't need to call `mwse.registerModConfig` or `mwse.mcm.register` if calling this function.
function mwseMCMTemplate:register() end

--- This method assigns a new function to `onClose` field that calls `mwse.saveConfig` with given parameters.
--- @param fileName string No description yet available.
--- @param config unknown No description yet available.
function mwseMCMTemplate:saveOnClose(fileName, config) end

--- This method assigns a custom search handler for the Template. This function should return true if this mod should show up in search results for given `searchText` (it's in lowercase).
--- @param callback nil|fun(searchText: string): boolean No description yet available.
function mwseMCMTemplate:setCustomSearchHandler(callback) end

